<?php
/*
	DevSaver Web Framework
	Copyright (c) 2013-2016 DevSaver. 
	All rights reserved.
		web:  www.devsaver.com
		mail: support@devsaver.com		
*/

// dependencies

/**
* description
*
* @library	
* @author	
* @since	
*/
class CCommon extends CPlugin{
	
	var $tplvars; 

	function __construct() {
		//$this->CPlugin($db, $tables , $templates);
	}

	function DoEvents(){
		global $base, $_CONF, $_TSM , $_VARS , $_USER , $_BASE , $_SESS;

		parent::DoEvents();
	}

	function __init() {
		global $_CONF;

		if ($this->__inited) {
			return "";
		}

		$this->__inited = true;
		
		$path = $this->tpl_path;

		$templates = array(
			"categories"				=> "categories.htm",
			"errors"					=> "errors.htm",
			"rating"					=> "rating.htm",
			"form"						=> "form.htm",

			"popup"						=> "popup.htm",
		);

		foreach ($templates as $key => $val) {
			$this->private->templates[$key] = new CTemplateDynamic(
				$path . $val
			);
		}
	} 

	function ErrorMsg($msg , $showempty = true) {

		if (!$msg && !$showempty ) {
			return "";
		}
		

		$this->__init();

		return $this->private->templates["errors"]->blockReplace(
			"Error" , 
			array(
				"msg"	=> is_array($msg) ? implode("<br>" , $msg) : $msg
			)
		);
	}
	
	function SuccessMsg($msg , $redirect = "" , $showempty = true) {

		if (!$msg && !$showempty ) {
			return "";
		}

		$this->__init();

		return $this->private->templates["errors"]->blockReplace(
			"Success" , 
			array(
				"msg"	=> $msg,
				"redirect"	=> $redirect ? $this->private->templates["errors"]->blockReplace("Redirect" , array("url" => $redirect)) : "",
			)
		);
	}

	function Redirect404() {
		global $_CONF;

		$module = $this->module->plugins["modules"]->GetModuleById($this->vars->data["set_404"]);
		header("HTTP/1.1 404 Not Found");
		header("Location: " . $this->module->plugins["modules"]->PrepareLink($module["mod_url"] . "/"));
		exit();
	}

	/**
	* description
	*
	* @param
	*
	* @return
	*
	* @access
	*/
	function LinkTarget($target = "") {
		return $target ? " target=\"{$target}\" " : "";
	}
	

	
	/**
	* description
	*
	* @param
	*
	* @return
	*
	* @access
	*/
	function BootstrapCol($size) {

		switch ($size) {
			case "1":  	return 12;break;
			case "2":  	return 6;break;
			case "3":  	return 4;break;
			case "4":  	return 3;break;
			case "6":  	return 2;break;
			case "12":  return 1;break;
		}		
	}

	
	/**
	* description
	*
	* @param
	*
	* @return
	*
	* @access
	*/
	function RatingStars($val) {
		$this->__init();

		$tpl = &$this->private->templates["rating"];

		$val = round($val);

		$data["star_1"] = $tpl->blockreplace($val >= 1 ? "Full" : "Empty");
		$data["star_2"] = $tpl->blockreplace($val >= 2 ? "Full" : "Empty");
		$data["star_3"] = $tpl->blockreplace($val >= 3 ? "Full" : "Empty");
		$data["star_4"] = $tpl->blockreplace($val >= 4 ? "Full" : "Empty");
		$data["star_5"] = $tpl->blockreplace($val >= 5 ? "Full" : "Empty");
		

		return $tpl->blockReplace("Main" , array("rate" => $val) , $data);
	}

	
	/**
	* description
	*
	* @param
	*
	* @return
	*
	* @access
	*/
	function FormBuilder($fields , $script , $style , $capcha_type , $extra = array()) {
		global $_LANG_ID , $_SESS , $_LANG_CODE , $base;

		$this->__init();

		$template = $this->private->templates["form"];


		if (is_array($fields)) {
			$cnt = 1;
			foreach ($fields as $key => $val) {

				$fields[$key]["field_required"] = $val["field_required"] = $val["item_required"] ? $template->blockReplace("field_required" , $val) : "";
				$fields[$key]["holder_required"] = $val["holder_required"] = $val["item_required"] ? $template->blockReplace("holder_required" , $val) : "";

				$val["value"] = $_GET[$val["item_field"]] ? $_GET[$val["item_field"]] : "";

				//prefill couple values from uyser if logged in 
				if (is_array($_SESS["client"]) && in_array($val["item_field"] , array("name" , "email" , "first_name" , "last_name"))) {

					switch ($val["item_field"]) {
						case "name":
							$val["value"] = $_SESS["client"]["user_first_name"] . " " . $_SESS["client"]["user_last_name"];
						break;

						case "first_name":
							$val["value"] = $_SESS["client"]["user_first_name"] ;
						break;

						case "last_name":
							$val["value"] = $_SESS["client"]["user_last_name"] ;
						break;

						case "email":
							$val["value"] = $_SESS["client"]["user_email"] ;
						break;

					}
					
				}
				

				switch ($val["item_type"]) {
					case "separator":
						$fields[$key]["content"] = $template->blockReplace(
							"separator",
							$val
						);
					break;

					case "departments":
						//nothing here
						
					break;

					default:				
						if ($val["item_type"] == "userdroplist") {
							$tmp = @explode("\n" , $val["item_options"]);
							foreach ($tmp as $k => $v) {
								$v = explode("|" , $v);
								if (trim($v[0])) {
									
									$val["options"] .= "<option " . ( trim($v[1]) == "1" ? "selected" : "" ) . ">" . trim($v[0]) . "</option>";
								}
							}
						}

						//size
						$val["field"] = $template->blockreplace(
							$val["item_type"], 
							$val
						);
						

						$fields[$key]["content"] = $template->blockReplace(
							$widget ? "Full" : ucwords($val["item_size"]),
							$val
						);
					break;
				}
				
			}
			
			$capcha = $this->plugins["antispam"]->GetCaptchaField($capcha_type);

			if (count($extra)) {
				foreach ($extra as $key => $val) {

					$extra_fields = $template->blockReplace(
						"Hidden" , 
						array(
							"name"	=> $key , 
							"value"	=> $val
						)
					);
				}				
			}
			

			return $template->blockReplace(
				"Form", 
				array(
					"style"		=> $style,
					"_LANG"		=> $_LANG_CODE,
					"fields"	=> $base->html->table(
						$template , 
						"" , 
						$fields
					),

					"script"	=> $script,
					"capcha"	=> $capcha,

					"hidden"	=> $extra_fields,

				)
			);

		}
	}

	/**
	* description
	*
	* @param
	*
	* @return
	*
	* @access
	*/
	function FormBuilderValidator($fields , $capcha_type) {
	}
	

	function urltolink($content) {

		$content = preg_replace('#(https?://[^\s]+(?=\.(jpe?g|png|gif)))(\.(jpe?g|png|gif))#i', '<img src="$1.$2" alt="$1.$2" />', $content);


		$content = preg_replace(
			"/\s*[a-zA-Z\/\/:\.]*youtu(be.com\/watch\?v=|.be\/)([a-zA-Z0-9\-_]+)([a-zA-Z0-9\/\*\-\_\?\&\;\%\=\.]*)/i",
			"<iframe src=\"//www.youtube.com/embed/$2\" allowfullscreen></iframe>",
			$content
		);


		$content = autolink($content , true);

		return $content;
	}


	/**
	* description
	*
	* @param
	*
	* @return
	*
	* @access
	*/
	function Popup($content , $btn , $bg = null) {
		global $_MODULES;

		$this->__init();


		if ($bg) {
			$bg = $_MODULES["backgrounds"]->GetBg($bg);
		} else {
			$bg = array(
				"class"	=> "nc"
			);
		}

		
		return $this->_t("popup")->blockReplace(
			"Main" , 
			array(
				"bg_class"	=> $bg["class"],
				"bg_html"	=> $bg["html"],

				"btn"		=> $btn ? $this->_t("popup")->blockReplace("Btn" , array("btn" => $btn)) : "",

				"content"	=> $content,
			), 
			$bg
		);	
	}


	/**
	* description
	*
	* @param
	*
	* @return
	*
	* @access
	*/
	function Json($data, $mime = true) {

		if ($mime ) {
			header("Content-Type: application/json; charset=utf-8");
		}

		return json_encode($data, JSON_HEX_QUOT | JSON_HEX_TAG | JSON_HEX_APOS);
	}
	

}

?>